#!/bin/tclsh
#do not call from other script which has acquired a lock!

set tmpdir /tmp/lcd_msg
if {![file isdirectory $tmpdir]} then {
    file mkdir $tmpdir
}

regexp -- {-g(roup)?\s*([\w+?]{1,6})} $argv dummy dummy groupname
if {![info exists groupname]} then {
  set groupname *
}

regexp -- {-i(d)?\s*([\w+?]{1,20})} $argv dummy dummy msgid
if {![info exists msgid]} then {
  set msgid *
}

#acquire lock
while {[catch {socket -server unknown -myaddr 127.0.0.1 451} locksock]} {after 100}

#delete msgs by calling them with parameter deletemsg=1
set deletemsg 1
foreach deletefile [glob -nocomplain [join "$tmpdir/msg_id $msgid grp $groupname.tcl" _]] {
  catch {source $deletefile}
  #just to be sure, if the file cannot delete itself in case of errors...
  catch {file delete $deletefile}
}
set deletemsg 0

close $locksock
