#!/bin/tclsh
#param0 = Number of backlight flashs
#param1 = timeout for backlight

set orig_file [open /usr/local/etc/config/hss_lcd_msg.conf "r"]
set orig_data [read $orig_file]
close $orig_file
exec rm /tmp/lcd_msg/hss_lcd.conf
if { $argc == 0 || [lindex $argv 0] > 0} then {
  regexp -nocase {dateformat\s*=\s*[%dmy]+} $orig_data df
  regexp -nocase {timeformat\s*=\s*[%HM]+} $orig_data tf
  set bright_data "BACKLIGHT = 2\nBACKLIGHT_UNIT = 1\nBRIGHTNESS = 15\nCONTRAST = 9\n$df\n$tf\n"
  set dark_data "BACKLIGHT = 2\nBACKLIGHT_UNIT = 1\nBRIGHTNESS = 0\nCONTRAST = 9\n$df\n$tf\n"
  set flashcount [expr {[lindex $argv 0] + ($argc > 1)}]
  for {set i 1} {$i < $flashcount} {incr i} {
    set flash_file [open /tmp/lcd_msg/hss_lcd.conf "w"]
    puts $flash_file $bright_data
    close $flash_file
    exec killall -SIGUSR1 hss_lcd
    after 1000
    set flash_file [open /tmp/lcd_msg/hss_lcd.conf "w"]
    puts $flash_file $dark_data
    close $flash_file
    exec killall -SIGUSR1 hss_lcd
    after 1000
  }
}
if {$argc > 1} then {
  regexp -nocase {brightness.*} $orig_data rest_of_orig
  set backlight_file [open /tmp/lcd_msg/hss_lcd.conf "w"]
  set backlight_data "BACKLIGHT = [lindex $argv 1]\nBACKLIGHT_UNIT = 1\n$rest_of_orig"
  puts $backlight_file $backlight_data
  close $backlight_file
  exec killall -SIGUSR1 hss_lcd
  after 1000
}
file delete /tmp/lcd_msg/hss_lcd.conf
exec ln -s /usr/local/etc/config/hss_lcd_msg.conf /tmp/lcd_msg/hss_lcd.conf

