#!/bin/tclsh
set tmpdir /tmp/lcd_msg

set readfile 1
set deletemsg 0
set deb stdout
if {[file exists /tmp/lcd_msg/debug.txt]} then {
  set deb [open /tmp/lcd_msg/debug.txt "a"]
}

puts $deb "<!-- START [clock seconds] -->" 
if { [info exists env(QUERY_STRING)] } {
  foreach pair [split $env(QUERY_STRING) &] {
    regexp "^(\[^=]*)=(.*)$" $pair dummy varname val
    set params($varname) $val
  }
}

if { [info exists params(deletegroup)] } then {
  set groupname $params(deletegroup)
  puts $deb "<!-- deleting group $groupname -->"
  source delete_msg.tcl
}

#set nextLcdTs 0
#source updateLcdVars.tcl
#catch {source $tmpdir/lcd_vars.tcl}
#use defaults for now
set dateformat "%d%m%y"
set timeformat "%H%M"
set TIMEOUT 30000
while {[catch {socket -server unknown -myaddr 127.0.0.1 451} locksock]} {after 100}
set lmv_files [glob -nocomplain -- $tmpdir/msg_id_*_grp_*.tcl]
set lmv_currentfileindex -1
catch {set lmv_currentfileindex $params(fileindex)}

#write header
puts "<hssml pagetype=\"MENU\">"
puts "<head>"
puts "<a href=\"http://127.0.0.1/addons/lcd_msg/hss_index.cgi\" key=\"7\" autoswitch=\"$TIMEOUT\"/>"
puts "<goto div=\"P_1\"/>"
puts "<date symbols format=\"$dateformat\"/>"
puts "<time symbols format=\"$timeformat\"/>"
puts "</head>"
puts $deb "<!-- lmv_currentfileindex = $lmv_currentfileindex -->"

puts "<body>"

#for personal use
catch {source $tmpdir/FSB_vars.tcl}
if { [file exists updateFSBdata.tcl] } then {
  catch {source updateFSBdata.tcl}
}
#end for personal use


while {$readfile} {
  
  set offdata ""
  #stop alarm
  set to_alarm 0
  catch {set to_alarm $params(to_alarm)}
  puts $deb "<!-- alarm =$to_alarm -->"
  if {$to_alarm != 0 && $to_alarm <= [clock seconds]} then {
    set offdata "ALARM=false"
    set to_alarm 0
  }
  
  #stop service
  set to_service 0
  catch {set to_service $params(to_service)}
  puts $deb "<!-- to_service =$to_service -->"
  if {$to_service != 0 && $to_service <= [clock seconds]} then {
    set offdata "$offdata SERVICE=0"
    set to_service 0
  }
  
  #stop service blink
  set to_sblink 0
  catch {set to_sblink $params(to_sblink)}
  puts $deb "<!-- to_sblink =$to_sblink -->"
  if {$to_sblink != 0 && $to_sblink <= [clock seconds]} then {
    set offdata "$offdata INSTALL_MODE=false"
    set to_sblink 0
  }
  
  puts $deb "<!-- offdata =$offdata -->"
  if {[string length "$offdata"]} then {
    set udpdata [join "[eval list REGAHSS $offdata] {}" \\n]
    catch {exec echo -e $udpdata | /etc/config/addons/lcd_msg/socat -u stdin UDP4:127.0.0.1:8182}
  }
    
  #keep track of backlight if new messages also need backlight, but for a shorter period
  set to_backlight 0
  catch {set to_backlight $params(to_backlight)}

  if {[llength $lmv_files] > 0} {
    if {$lmv_currentfileindex < 0} {
      set lmv_currentfileindex 0
    } elseif {$lmv_currentfileindex >= [llength $lmv_files]} {
      set lmv_currentfileindex [expr {[llength $lmv_files] - 1} ]
    }
  } else {
    set lmv_currentfileindex -1
    break
  }
  set prev_msg "href=\"http://127.0.0.1/addons/lcd_msg/hss_index.cgi?to_alarm=\$to_alarm&to_service=\$to_service&to_sblink=\$to_sblink&to_backlight=\$to_backlight&fileindex=[expr " ($lmv_currentfileindex - 1) % [llength $lmv_files] "]\""
  set next_msg "href=\"http://127.0.0.1/addons/lcd_msg/hss_index.cgi?to_alarm=\$to_alarm&to_service=\$to_service&to_sblink=\$to_sblink&to_backlight=\$to_backlight&fileindex=[expr " ($lmv_currentfileindex + 1) % [llength $lmv_files] "]\""
  if { [llength $lmv_files] > 1 } then {
    set singlepage_minus_key "<a \[subst $prev_msg] key=1/>"
    set singlepage_plus_key  "<a \[subst $next_msg] key=4/>"
  } else {
    set singlepage_minus_key "<a href=\"#M_99\" key=1 duration=5/>"
    set singlepage_plus_key "<a href=\"#M_99\" key=4 duration=5/>"
  }
  set nextfile [lindex $lmv_files $lmv_currentfileindex]
  if { [file exists $nextfile] } then {
    set skipfile 0
    if {[catch {source $nextfile} err]} then {
      puts $deb "error in source $nextfile: $err"
      file rename -force -- $nextfile "[string range $nextfile 0 end-4].err"
    }
  } else {
    set lmv_files [lreplace $lmv_files $lmv_currentfileindex $lmv_currentfileindex]
    saveVars $tmpdir/lmv_files.tcl "lmv_files"
    set lmv_currentfileindex [expr {[llength $lmv_files] - 1 }]
    puts "<div name=\"P_1\">$nextfile</br>not found<a href=\"http://127.0.0.1/addons/lcd_msg/hss_index.cgi?to_alarm=$to_alarm&to_service=$to_service&to_sblink=$to_sblink&to_backlight=$to_backlight\" key=7 autoswitch=5000/></div></body></hssml>"
    return
  }
  puts $deb "<!--vars readfile=$readfile to_alarm=$to_alarm to_service=$to_service-->"
}

if {![string equal $deb stdout]} then {
  close $deb
}
close $locksock

if { $lmv_currentfileindex == -1 } then {
  puts "<div name=\"P_1\"><skip count=4/>CCU     HomeMatic<a href=\"#M_99\" key=1 duration=5/><a href=\"#M_01\" key=2/><a href=\"#M_99\" key=4 duration=5/><a href=\"http://127.0.0.1/addons/lcd_msg/hss_index.cgi?to_alarm=$to_alarm&to_service=$to_service&to_sblink=$to_sblink&to_backlight=$to_backlight\" key=7 autoswitch=2500/></div>"
}

puts "<div name=\"M_01\"><skip/>Hauptmenu<br/>Anlernen<a href=\"#M_02\" key=4/><a href=\"#M_06\" key=1/><a href=\"http://127.0.0.1/addons/lcd_msg/newdevice.cgi\"                key=2/></div>"
puts "<div name=\"M_02\"><skip/>Hauptmenu<br/>Netzwerk<a href=\"#M_03\" key=4/><a href=\"#M_01\" key=1/><a href=\"http://127.0.0.1/addons/lcd_msg/network.cgi\"                  key=2/></div>"
puts "<div name=\"M_03\"><skip/>Hauptmenu<br/>Zeit<a     href=\"#M_04\" key=4/><a href=\"#M_02\" key=1/><a href=\"http://127.0.0.1/addons/lcd_msg/datetime.cgi?sDivname=DT_01\"  key=2/></div>"
puts "<div name=\"M_04\"><skip/>Hauptmenu<br/>LCD<a      href=\"#M_05\" key=4/><a href=\"#M_03\" key=1/><a href=\"http://127.0.0.1/addons/lcd_msg/display.cgi?sDivname=DP_01\"   key=2/></div>"
puts "<div name=\"M_05\"><skip/>Hauptmenu<br/>WLan<a     href=\"#M_06\" key=4/><a href=\"#M_04\" key=1/><a href=\"http://127.0.0.1/addons/lcd_msg/wlan.cgi\"                     key=2/></div>"
puts "<div name=\"M_06\"><skip/>Hauptmenu<br/>Zurck<a   href=\"#M_01\" key=4/><a href=\"#M_05\" key=1/><a href=\"http://127.0.0.1/addons/lcd_msg/hss_index.cgi?to_alarm=$to_alarm&to_service=$to_service&to_sblink=$to_sblink&to_backlight=$to_backlight&fileindex=$lmv_currentfileindex\"                key=2/></div>"
puts {<div name="M_99"><form action="http://127.0.0.1/addons/lcd_msg/newdevice.cgi" method="get" enctype="text/plain"><input type="hidden" name="sRedirectURL" value="%22http://127.0.0.1/addons/lcd_msg/newdevice.cgi?sDivname=ND_03%22"/><input type="hidden" name="sInstallMode" value="true"/><input type="submit" key="2"/></form><a href="?submit" key="2" autoswitch="1"/></div>}

puts {</body>}
puts {</hssml>}
