#!/bin/tclsh
#Version 1.0
#param 0 = PLZ

load tclrega.so

set url http://www.google.com/ig/api?weather=[lindex $argv 0]-Germany&hl=de
exec /usr/bin/wget -q -O /tmp/weatherdata.xml $url
set f [open "/tmp/weatherdata.xml"]
set input [read $f]
close $f
regexp "<current_conditions>(.*)</current_conditions>" $input dummy current
foreach tag [split $current >] {
  regexp {<([^=>]*) data="([^=>"]*)"/} $tag dummy key value
  set aCurrent($key) "$value"
}
regexp "Wind: (\\w+) mit (\\d+) " $aCurrent(wind_condition) dummy winddirection windspeed
regexp "Feuchtigkeit: (\\d+)" $aCurrent(humidity) dummy humidity

#lcd_msg region
if {[file exists /etc/config/addons/lcd_msg/display_msg.sh]} then {
  set wind [string range [join "$windspeed $winddirection" ""] 0 3]
  if {[string length $wind] > 3 && [string length $aCurrent(temp_c)] > 1} then {set wind [string range $wind 0 2]}
  set disp_humidity $humidity
  if {$humidity == 100 && [expr {[string length $wind] + [string length $aCurrent(temp_c)]}] > 4} then {set disp_humidity 99}
  
  regexp "<forecast_conditions>.*?</forecast_conditions>.*?<forecast_conditions>(.*?)</forecast_conditions>" $input dummy forecast
  foreach tag [split $forecast >] {
    regexp {<([^=>]*) data="([^=>"]*)"/} $tag dummy key value
    set aForecast($key) "$value"
  }
  set tomorrow $aForecast(condition)
  switch $tomorrow {
    "Vereinzelt Schnee" {set tomorrow "schnee"}
    "Vereinzelt Regen"  {set tomorrow "regen"}
    "Meistens bewlkt"  {set tomorrow "Wolken"}
    "Klar"              {set tomorrow "SONNE"}
    "Meist sonnig"      {set tomorrow "Sonne"}
    "Teils sonnig"      {set tomorrow "sonne"}
    "Teils bewlkt"     {set tomorrow "wolken"}
  }
  set tomorrow_temp [join "$aForecast(low) / $aForecast(high)" ""]
  set tomorrow [join "$tomorrow \{[string repeat " " [expr {11-[string length $tomorrow$tomorrow_temp]}]]\} $tomorrow_temp" ""]
  set weather_msg "\$m4h s4s gwetter\$$aCurrent(temp_c) $disp_humidity% $wind<br/>$tomorrow"
  puts $weather_msg
  catch {exec /bin/sh /etc/config/addons/lcd_msg/display_msg.sh "$weather_msg"}
}

set rega_cmd ""
append rega_cmd "var OTempO = dom.GetObject('A-Temperatur');"
append rega_cmd "var OHumiO = dom.GetObject('A-Luftfeuchtigkeit');"
append rega_cmd "var WindspeedO = dom.GetObject('Windgeschwindigkeit');"
append rega_cmd "var WinddirectionO = dom.GetObject('Windrichtung');"
append rega_cmd "var WeatherO = dom.GetObject('Wetterbedingung');"
append rega_cmd "OTempO.State('$aCurrent(temp_c)');"
append rega_cmd "OHumiO.State('$humidity');"
append rega_cmd "WindspeedO.State('$windspeed');"
append rega_cmd "WinddirectionO.State('$winddirection');"
append rega_cmd "WeatherO.State('$aCurrent(condition)');"
rega_script $rega_cmd
